﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http.Headers;
using System.Text;
using System.Threading.Tasks;

namespace tiktokdemo
{
    public class HttpHelper
    {
        public HttpClient client { get; set; }

   

        public bool HttpClientTest(string url)
        {

            HttpClientHandler httpClientHandler = new HttpClientHandler
            {
                AutomaticDecompression = DecompressionMethods.All,

            };

            client = new HttpClient(httpClientHandler);

            client.Timeout = new TimeSpan(0, 0, 0, 100);

            return true;
        }



        public async Task<string> PostAsync(string url, byte[] data)//post异步请求方法
        {
            string str = "";
            try
            {
                if (client == null)
                {
                    HttpClientTest(url);
                }

                ByteArrayContent request = new ByteArrayContent(data);

                request.Headers.ContentType = new MediaTypeHeaderValue("application/json");

                var res = await client.PostAsync(url, request);

                str = await res.Content.ReadAsStringAsync();

                return str;

            }
            catch (Exception ex)
            {

                str = "{\"code\":-2,\"message\":\"" + ex.ToString() + "\"}";

            }
            return str;
        }







        public async Task<string> PostAsync(string url, Dictionary<string, string> heraders, byte[] data)//post异步请求方法
        {
            string str = "";
            try
            {
                if (client == null)
                {
                    HttpClientTest(url);
                }

                foreach (var item in heraders)
                {
                    client.DefaultRequestHeaders.TryAddWithoutValidation(item.Key, item.Value);

                }

                ByteArrayContent request = new ByteArrayContent(data);



                var res = await client.PostAsync(url, request);


                str = await res.Content.ReadAsStringAsync();

                return str;

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());

                str = "{\"code\":-2,\"message\":\"" + ex.ToString() + "\"}";

            }
            return str;
        }


        public async Task<byte[]> PostAsyncBytes(string url, Dictionary<string, string> heraders, byte[] data)//post异步请求方法
        {
            byte[] str=new byte[0];
            try
            {
                if (client == null)
                {
                    HttpClientTest(url);
                }

                foreach (var item in heraders)
                {
                    client.DefaultRequestHeaders.TryAddWithoutValidation(item.Key, item.Value);

                }

                ByteArrayContent request = new ByteArrayContent(data);



                var res = await client.PostAsync(url, request);


                str = await res.Content.ReadAsByteArrayAsync();

                return str;

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());

            }
            return str;
        }









    }
}
